/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.whiteboard;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.spi.whiteboard.Tracker;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;

public abstract class AbstractServiceTracker<T> {
    private final Tracker<T> stopped = new Tracker<T>(){

        @Override
        public List<T> getServices() {
            return Collections.emptyList();
        }

        @Override
        public void stop() {
        }
    };
    private final Class<T> type;
    private volatile Tracker<T> tracker = this.stopped;

    protected AbstractServiceTracker(@Nonnull Class<T> type) {
        this.type = Preconditions.checkNotNull(type);
    }

    public synchronized void start(Whiteboard whiteboard) {
        Preconditions.checkState(this.tracker == this.stopped);
        this.tracker = whiteboard.track(this.type);
    }

    public synchronized void stop() {
        if (this.tracker != this.stopped) {
            Tracker<T> t = this.tracker;
            this.tracker = this.stopped;
            t.stop();
        }
    }

    protected List<T> getServices() {
        return this.tracker.getServices();
    }
}

