/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.commons.providers;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.sling.discovery.ClusterView;
import org.apache.sling.discovery.InstanceDescription;
import org.apache.sling.discovery.commons.providers.DefaultClusterView;
import org.apache.sling.discovery.commons.providers.util.PropertyNameHelper;

public class DefaultInstanceDescription
implements InstanceDescription {
    private ClusterView clusterView;
    private boolean isLeader;
    private boolean isLocal;
    private String slingId;
    private Map<String, String> properties;

    public DefaultInstanceDescription(DefaultClusterView clusterView, boolean isLeader, boolean isOwn, String slingId, Map<String, String> properties) {
        if (slingId == null || slingId.length() == 0) {
            throw new IllegalArgumentException("slingId must not be null");
        }
        this.isLeader = isLeader;
        this.isLocal = isOwn;
        this.slingId = slingId;
        this.properties = this.filterValidProperties(properties);
        if (clusterView != null) {
            clusterView.addInstanceDescription(this);
            if (this.clusterView == null) {
                throw new IllegalStateException("clusterView should have been set by now");
            }
        }
    }

    public String toString() {
        String clusterInfo = this.clusterView == null ? "" : ", clusterViewId=" + this.clusterView.getId();
        return "an InstanceDescription[slindId=" + this.slingId + ", isLeader=" + this.isLeader + ", isOwn=" + this.isLocal + clusterInfo + ", properties=" + this.properties + "]";
    }

    public int hashCode() {
        return this.slingId.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof DefaultInstanceDescription)) {
            return false;
        }
        DefaultInstanceDescription other = (DefaultInstanceDescription)obj;
        if (!this.slingId.equals(other.slingId)) {
            return false;
        }
        if (!this.slingId.equals(other.slingId)) {
            return false;
        }
        if (!this.properties.equals(other.properties)) {
            return false;
        }
        return this.getClusterView().getId().equals(other.getClusterView().getId());
    }

    @Override
    public ClusterView getClusterView() {
        if (this.clusterView == null) {
            throw new IllegalStateException("clusterView was never set");
        }
        return this.clusterView;
    }

    void setClusterView(ClusterView clusterView) {
        if (this.clusterView != null) {
            throw new IllegalStateException("can only set clusterView once");
        }
        if (clusterView == null) {
            throw new IllegalArgumentException("clusterView must not be null");
        }
        this.clusterView = clusterView;
    }

    @Override
    public boolean isLeader() {
        return this.isLeader;
    }

    @Override
    public boolean isLocal() {
        return this.isLocal;
    }

    @Override
    public String getSlingId() {
        return this.slingId;
    }

    @Override
    public String getProperty(String name) {
        if (this.properties == null) {
            throw new IllegalStateException("properties were never set");
        }
        return this.properties.get(name);
    }

    @Override
    public Map<String, String> getProperties() {
        if (this.properties == null) {
            throw new IllegalStateException("properties were never set");
        }
        return Collections.unmodifiableMap(this.properties);
    }

    protected void setProperties(Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException("properties must not be null");
        }
        this.properties = this.filterValidProperties(properties);
    }

    private Map<String, String> filterValidProperties(Map<String, String> rawProps) {
        if (rawProps == null) {
            return null;
        }
        HashMap<String, String> filteredProps = new HashMap<String, String>();
        Set<Map.Entry<String, String>> entries = rawProps.entrySet();
        for (Map.Entry<String, String> anEntry : entries) {
            if (!PropertyNameHelper.isValidPropertyName(anEntry.getKey())) continue;
            filteredProps.put(anEntry.getKey(), anEntry.getValue());
        }
        return filteredProps;
    }

    public void setProperty(String key, String value) {
        if (!PropertyNameHelper.isValidPropertyName(key)) {
            throw new IllegalArgumentException("key is not a valid property name: " + key);
        }
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(key, value);
    }
}

