/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.commons.providers.base;

import org.apache.sling.discovery.TopologyEvent;
import org.apache.sling.discovery.TopologyEventListener;
import org.apache.sling.discovery.commons.providers.base.AsyncEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AsyncTopologyEvent
implements AsyncEvent {
    static final Logger logger = LoggerFactory.getLogger(AsyncTopologyEvent.class);
    final TopologyEventListener listener;
    final TopologyEvent event;

    AsyncTopologyEvent(TopologyEventListener listener, TopologyEvent event) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        if (event == null) {
            throw new IllegalArgumentException("event must not be null");
        }
        this.listener = listener;
        this.event = event;
    }

    public String toString() {
        return "an AsyncTopologyEvent[event=" + this.event + ", listener=" + this.listener + "]";
    }

    @Override
    public void trigger() {
        logger.trace("trigger: start");
        try {
            logger.debug("trigger: sending to listener: {}, event: {}", (Object)this.listener, (Object)this.event);
            this.listener.handleTopologyEvent(this.event);
        }
        catch (Exception e) {
            logger.warn("trigger: handler threw exception. handler: " + this.listener + ", exception: " + e, (Throwable)e);
        }
        logger.trace("trigger: end: listener: {}, event: {}", (Object)this.listener, (Object)this.event);
    }
}

