/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.commons.providers.spi.base;

import javax.jcr.Session;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONObject;

public class DiscoveryLiteDescriptor {
    public static final String OAK_DISCOVERYLITE_CLUSTERVIEW = "oak.discoverylite.clusterview";
    private final JSONObject descriptor;

    public static DiscoveryLiteDescriptor getDescriptorFrom(ResourceResolver resourceResolver) throws Exception {
        Session session = resourceResolver.adaptTo(Session.class);
        if (session == null) {
            throw new Exception("Could not adapt resourceResolver to session: " + resourceResolver);
        }
        String descriptorStr = session.getRepository().getDescriptor(OAK_DISCOVERYLITE_CLUSTERVIEW);
        if (descriptorStr == null) {
            throw new Exception("No Descriptor value available");
        }
        JSONObject descriptor = new JSONObject(descriptorStr);
        return new DiscoveryLiteDescriptor(descriptor);
    }

    DiscoveryLiteDescriptor(JSONObject descriptor) {
        this.descriptor = descriptor;
    }

    public int getMyId() throws Exception {
        Object meObj = this.descriptor.get("me");
        if (meObj == null || !(meObj instanceof Number)) {
            throw new Exception("getMyId: 'me' value of descriptor not a Number: " + meObj + " (descriptor: " + this.descriptor + ")");
        }
        Number me = (Number)meObj;
        return me.intValue();
    }

    private int[] getArray(String name) throws Exception {
        Object deactivatingObj = this.descriptor.get(name);
        if (deactivatingObj == null || !(deactivatingObj instanceof JSONArray)) {
            throw new Exception("getArray: '" + name + "' value of descriptor not an array: " + deactivatingObj + " (descriptor: " + this.descriptor + ")");
        }
        JSONArray deactivating = (JSONArray)deactivatingObj;
        int[] result = new int[deactivating.length()];
        for (int i = 0; i < deactivating.length(); ++i) {
            Object obj = deactivating.get(i);
            if (obj == null || !(obj instanceof Number)) {
                throw new Exception("getArray: '" + name + "' at " + i + " null or not a number: " + obj + ", (descriptor: " + this.descriptor + ")");
            }
            result[i] = ((Number)obj).intValue();
        }
        return result;
    }

    public int[] getDeactivatingIds() throws Exception {
        return this.getArray("deactivating");
    }

    public int[] getActiveIds() throws Exception {
        return this.getArray("active");
    }

    public String getViewId() throws Exception {
        if (this.descriptor.isNull("id")) {
            return null;
        }
        Object idObj = this.descriptor.get("id");
        if (idObj == null || !(idObj instanceof String)) {
            throw new Exception("getViewId: 'id' value of descriptor not a String: " + idObj + " (descriptor: " + this.descriptor + ")");
        }
        return String.valueOf(idObj);
    }

    public String toString() {
        return this.getDescriptorStr();
    }

    public String getDescriptorStr() {
        return this.descriptor.toString();
    }

    public Long getSeqNum() throws Exception {
        Object seqObj = this.descriptor.get("seq");
        if (seqObj == null || !(seqObj instanceof Number)) {
            throw new Exception("getSeqNum: 'seq' value of descriptor not a Number: " + seqObj + " (descriptor: " + this.descriptor + ")");
        }
        Number seqNum = (Number)seqObj;
        return seqNum.longValue();
    }

    public boolean isFinal() throws Exception {
        Object finalObj = this.descriptor.get("final");
        if (finalObj == null || !(finalObj instanceof Boolean)) {
            throw new Exception("isFinal: 'final' value of descriptor not a Boolean: " + finalObj + " (descriptor: " + this.descriptor + ")");
        }
        Boolean isFinal = (Boolean)finalObj;
        return isFinal;
    }
}

