/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.hc.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.sling.hc.api.HealthCheck;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthCheckFilter {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final BundleContext bundleContext;
    public static final String OMIT_PREFIX = "-";
    private final Set<ServiceReference> usedReferences = new HashSet<ServiceReference>();

    public HealthCheckFilter(BundleContext bc) {
        this.bundleContext = bc;
    }

    public List<HealthCheck> getTaggedHealthChecks(String ... tags) {
        ServiceReference[] refs = this.getTaggedHealthCheckServiceReferences(tags);
        ArrayList<HealthCheck> result = new ArrayList<HealthCheck>();
        if (refs != null) {
            List<ServiceReference> sortedRefs = Arrays.asList(refs);
            Collections.sort(sortedRefs);
            for (ServiceReference ref : sortedRefs) {
                HealthCheck hc = (HealthCheck)this.bundleContext.getService(ref);
                this.log.debug("Selected HealthCheck service {}", (Object)hc);
                if (hc == null) continue;
                this.usedReferences.add(ref);
                result.add(hc);
            }
        }
        return result;
    }

    public ServiceReference[] getTaggedHealthCheckServiceReferences(String ... tags) {
        return this.getTaggedHealthCheckServiceReferences(false, tags);
    }

    public ServiceReference[] getTaggedHealthCheckServiceReferences(boolean combineWithOr, String ... tags) {
        StringBuilder filterBuilder = new StringBuilder();
        filterBuilder.append("(&(objectClass=").append(HealthCheck.class.getName()).append(")");
        int prefixLen = OMIT_PREFIX.length();
        StringBuilder filterBuilderForOrOperator = new StringBuilder();
        for (String tag : tags) {
            if ((tag = tag.trim()).length() == 0) continue;
            if (tag.startsWith(OMIT_PREFIX)) {
                filterBuilder.append("(!(").append("hc.tags").append("=").append(tag.substring(prefixLen)).append("))");
                continue;
            }
            if (combineWithOr) {
                filterBuilderForOrOperator.append("(").append("hc.tags").append("=").append(tag).append(")");
                continue;
            }
            filterBuilder.append("(").append("hc.tags").append("=").append(tag).append(")");
        }
        if (filterBuilderForOrOperator.length() > 0) {
            filterBuilder.append("(|").append((CharSequence)filterBuilderForOrOperator).append(")");
        }
        filterBuilder.append(")");
        this.log.debug("OSGi service filter in getTaggedHealthCheckServiceReferences(): {}", (Object)filterBuilder);
        try {
            String filterString = filterBuilder.length() == 0 ? null : filterBuilder.toString();
            this.bundleContext.createFilter(filterString);
            ServiceReference[] refs = this.bundleContext.getServiceReferences(HealthCheck.class.getName(), filterString);
            if (refs == null) {
                this.log.debug("Found no HealthCheck services with filter [{}]", (Object)filterString);
                return new ServiceReference[0];
            }
            this.log.debug("Found {} HealthCheck services with filter [{}]", (Object)refs.length, (Object)filterString);
            return refs;
        }
        catch (InvalidSyntaxException ise) {
            this.log.error("Invalid OSGi filter syntax in '" + filterBuilder + "'", (Throwable)ise);
            return new ServiceReference[0];
        }
    }

    public void dispose() {
        for (ServiceReference ref : this.usedReferences) {
            this.bundleContext.ungetService(ref);
        }
        this.usedReferences.clear();
    }
}

