/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.address.api.location;

import java.util.HashMap;
import java.util.Map;

/**
 * Stores and manages a set of latitude and longitude coordinates.
 */
public final class Coordinates {

    private Double lat, lng;

    public Coordinates(final String lat, final String lng) {
        if (lat != null) {
            this.lat = new Double(lat);
        }
        if (lng != null) {
            this.lng = new Double(lng);
        }
    }

    public Coordinates(final Double lat, final Double lng) {
        this.lat = lat;
        this.lng = lng;
    }

    public Double getLat() {
        return lat;
    }

    public void setLat(Double lat) {
        this.lat = lat;
    }

    public Double getLng() {
        return lng;
    }

    public void setLng(Double lng) {
        this.lng = lng;
    }

    public Boolean validate() {
        return (this.lat != null && this.lng != null);
    }

    public Map<String, Double> toPropertyMap() {
        Map<String, Double> props = new HashMap<String, Double>();
        props.put(Location.LATITUDE, getLat());
        props.put(Location.LONGITUDE, getLng());
        return props;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Coordinates latLng = (Coordinates) o;

        if (lat != null ? !lat.equals(latLng.lat) : latLng.lat != null) return false;
        if (lng != null ? !lng.equals(latLng.lng) : latLng.lng != null) return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result = lat != null ? lat.hashCode() : 0;
        result = 31 * result + (lng != null ? lng.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "Coordinates{" + "lat=" + lat + ", lng=" + lng + '}';
    }

}