/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.address.api.location;

import com.adobe.cq.address.api.AddressException;

/**
 * The <code>GeocodeProvider</code> provides an interface to convert address strings into latitude
 * and longitude coordinates and back to addresses again.
 */
public interface GeocodeProvider {

    /**
     * Convert an address into geographic coordinates (latitude and longitude).
     *
     * @param address Address string to geocode.
     * @return Geocoded coordinates for address
     * @throws AddressException
     */
    Coordinates geocode(String address) throws AddressException;

    /**
     * Convert geographic coordinates (latitude and longitude) into a
     * human-readable address.
     *
     * @param coords Coordinates to determine address from.
     * @return Closest matching address to provided coordinates.
     * @throws AddressException
     */
    String reverseGeocode(Coordinates coords) throws AddressException;
}
