/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.commerce.api;

import aQute.bnd.annotation.ProviderType;

/**
 * Various constants used in the Commerce API.
 */
@ProviderType
public interface CommerceConstants {

    /**
     * Used to pick a specific implementation behind the Commerce API.  See {@link CommerceServiceFactory}.
     */
    public final static String PN_COMMERCE_PROVIDER = "cq:commerceProvider";

    public final static String COMMERCE_COOKIE_NAME = "CommercePersistence";

    /**
     * Service name that refers to the generic eCommerce service which provides product information, cart management etc.
     * @see CommerceService#isAvailable(String)
     */
    public final static String SERVICE_COMMERCE = "commerce-service";



    /**
     * Special-case type handling.
     * <ol>
     *     <li>When <code>"product"</code> or <code>"variant"</code>, denotes a subtype of
     *         <code>commerce/components/product</code></li>
     *     <li>When <code>"section"</code>, denotes any page which was <i>produced</i> by a
     *         blueprint of type <code>commerce/components/section</code></li>
     * </ol>
     */
    public final static String PN_COMMERCE_TYPE = "cq:commerceType";

    /**
     * Defines which properties of a product produce its variations.  See {@link Product}.
     */
    public final static String PN_PRODUCT_VARIANT_AXES = "cq:productVariantAxes";

    /**
     * Defines the location of the cart page for the current site / tree.
     */
    public final static String PN_CART_PAGE_PATH = "cq:cartPage";

    /**
     * Defines the location of the checkout page for the current site / tree.
     */
    public final static String PN_CHECKOUT_PAGE_PATH = "cq:checkoutPage";

    /**
     * Points back to PIM data for a product.  See {@link Product}.
     */
    public final static String PN_PRODUCT_DATA = "productData";

    /**
     * A resource which proxies both a page and a product.
     */
    public final static String RT_PRODUCT_PAGE_PROXY = "commerce/components/productpageproxy";

    /**
     * A property which overrides the default setting controlling whether or not a proxy page is generated.
     */
    public final static String PN_PROXY_PAGE_OVERRIDE = "cq:proxyPageOverride";



    /**
     * The order property key which stores the path/ID of the chosen payment method.
     *
     * NB: convention used by OOTB order & checkout components.  NOT REQUIRED by the Commerce API.
     */
    public final static String PAYMENT_OPTION = "payment-option";

    /**
     * The order property key of the token for a tokenized payment.  Appears in place of the payment
     * info (not within).
     *
     * NB: convention used by OOTB order & checkout components.  NOT REQUIRED by the Commerce API.
     */
    public final static String PAYMENT_TOKEN = "paymentToken";




    /**
     * The order property key of a flag which indicates that the shipping address should be
     * auto-generated from the billing address.
     *
     * NB: convention used by OOTB order & checkout components.  NOT REQUIRED by the Commerce API.
     */
    public final static String SHIPPING_ADDR_SAME = "shippingAddressSameAsBilling";

    /**
     * The predicate (and prefix) of order property keys comprising the billing address.
     *
     * NB: convention used by OOTB order & checkout components.  NOT REQUIRED by the Commerce API.
     */
    public final static String BILLING_ADDRESS_PREDICATE = "billing";

    /**
     * The predicate (and prefix) of order property keys comprising the shipping address.
     *
     * NB: convention used by OOTB order & checkout components.  NOT REQUIRED by the Commerce API.
     */
    public final static String SHIPPING_ADDRESS_PREDICATE = "shipping";

    /**
     * The order property key which stores the path/ID of the chosen shipping method.
     *
     * NB: convention used by OOTB order & checkout components.  NOT REQUIRED by the Commerce API.
     */
    public final static String SHIPPING_OPTION = "shipping-option";



    /**
     * Convention used by OOTB order & checkout components.  Not required by the Commerce API.
     */
    public final static String REQ_ATTR_COUNTRYLIST = "cq.commerce.countries";
    /**
     * Convention used by OOTB order & checkout components.  Not required by the Commerce API.
     */
    public final static String REQ_ATTR_CARTPAGE = "cq.commerce.cartPage";
    /**
     * Convention used by OOTB order & checkout components.  Not required by the Commerce API.
     */
    public final static String REQ_ATTR_PRODNOTFOUNDPAGE = "cq.commerce.prodNotFoundPage";
    /**
     * Convention used by OOTB order & checkout components.  Not required by the Commerce API.
     */
    public final static String REQ_ATTR_CARTOBJECT = "cq.commerce.cartObject";



    /**
     * Convention used by OOTB order & checkout components.  Not required by the Commerce API.
     */
    public final static String OPEN_ORDERS_PREDICATE = "openOrders";



    /*
     * ==================================================================================================
     * Deprecated constants.  For backwards-compatibility only.
     * ==================================================================================================
     */

    /**
     * @deprecated since 5.6, use {@link #PN_COMMERCE_PROVIDER} instead.
     */
    @Deprecated
    public final static String PROPERTY_COMMERCE_PROVIDER = PN_COMMERCE_PROVIDER;

    /**
     * @deprecated since 5.6, use {@link #COMMERCE_COOKIE_NAME} instead.
     */
    @Deprecated
    public final static String COMMERCE_COOKIE_PREFIX = "CommercePersistence-";

    /**
     * @deprecated since 6.1, use {@link #BILLING_ADDRESS_PREDICATE} + "." or a predicate-based
     * property fetch ({@link CommerceSession#getOrderDetails(String predicate)}).
     */
    @Deprecated
    public final static String BILLING_PREFIX = "billing.";
    /**
     * @deprecated since 6.1, use {@link #SHIPPING_ADDRESS_PREDICATE} + "." or a predicate-based
     * property fetch ({@link CommerceSession#getOrderDetails(String predicate)}).
     */
    @Deprecated
    public final static String SHIPPING_PREFIX = "shipping.";
    /**
     * @deprecated since 6.1, use {@link PaymentMethod#getPredicate} + "." or a predicate-based
     * property fetch ({@link CommerceSession#getOrderDetails(String predicate)}).
     */
    @Deprecated
    public final static String PAYMENT_PREFIX = "payment.";
}
