/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.commerce.api;

import aQute.bnd.annotation.ConsumerType;

import java.util.List;

/**
 * Class that describes a facet
 */
@ConsumerType
public interface CommerceFacet {
    
    /**
     * Get the unique id of this facet
     */
    public String getId();
    
    /**
     * Get the display name of this facet, as it should be presented to the user
     */
    public String getDisplayName();
    
    /**
     * Get whether multiple values can be selected for this facet or not
     */
    public boolean isMultiSelect();
    
    /**
     * Get the list of values (selected or not) for this facet
     */
    public List<CommerceFacetValue> getValues();
    
}
