/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.commerce.api;

import aQute.bnd.annotation.ConsumerType;

@ConsumerType
public interface CommerceFacetValue {

    /**
     * Get the identifier of this value (i.e. the facet value)
     */
    public String getId();

    /**
     * Get the display name of this value, as it should be presented to the user
     */
    public String getDisplayName();
    
    /**
     * Get the number of products that would be returned if this value was applied to the current query. If this
     * information is not available, return -1.
     */
    public int getProductCount();

    /**
     * Get whether this value is selected for the current facet
     */
    public boolean isSelected();

}
