/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.commerce.api;

import aQute.bnd.annotation.ConsumerType;

import java.util.List;

/**
 * Class that describes a search result.
 */
@ConsumerType
public interface CommerceResult {

    /**
     * Get pagination information, like page number, total results, ...
     * @return
     */
    public PaginationInfo getPaginationInfo();

    /**
     * Get the available sort fields for this query.
     * @return
     */
    public List<CommerceSort> getSorts();

    /**
     * Get the current range of products returned by this query.
     * @return
     */
    public List<Product> getProducts();

    /**
     * Get the original query that generated the current result.
     * @return
     */
    public CommerceQuery getOriginalQuery();

    /**
     * Get the query as interpreted by the current commerce service. Implementations can return {@code null} here if
     * they don't have that information.
     * @return
     */
    public CommerceQuery getActualQuery();
    
    /**
     * Get a list of facets this query supports.
     * @return
     */
    public List<CommerceFacet> getFacets();

}
