/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.commerce.api;

import aQute.bnd.annotation.ProviderType;
import org.apache.sling.api.resource.Resource;

/**
 * A <code>CommerceServiceFactory</code> constructs an implementation of a {@link CommerceService},
 * which is the root of the Commerce API.  Other classes are fetched through the CommerceService.
 *
 * Individual resources in the repository can nominate a particular implementation of the
 * {@link CommerceService} through their {@link CommerceConstants#PN_COMMERCE_PROVIDER} properties.
 *
 * A {@link CommerceService} is then normally fetched using the adapter pattern:
 * <code>resource.adaptTo(CommerceService.class)</code>
 */
@ProviderType
public interface CommerceServiceFactory {

    /**
     * Name of the service property indicating the particular implementation this factory provides,
     * e.g. geometrixx.
     *
     * Not to be confused with {@link CommerceConstants#PN_COMMERCE_PROVIDER}, which names a resource
     * property whose value is matched at runtime with the service property to pick a factory.
     */
    public static final String PROPERTY_COMMERCE_PROVIDER = "commerceProvider";

    /**
     * Optional property used to describe this commerce provider in a user-interface (such as to allow
     * its selection from a drop-down menu).
     */
    public static final String PROPERTY_COMMERCE_PROVIDER_LABEL = "commerceProviderLabel";

    /**
     * Get a <code>CommerceService</code> implementation for a resource.
     * @param res
     * @return
     */
    public CommerceService getCommerceService(Resource res);
}
