/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.commerce.api;

import aQute.bnd.annotation.ConsumerType;

/**
 * Interface that describes a search sort (i.e. a sortable field).
 */
@ConsumerType
public interface CommerceSort {

    /**
     * @return the unique ID of this sort, which can be passed to a search query (e.g. "name-asc")
     */
    public String getId();

    /**
     * @return the human readable name of this sort (e.g. "Name (ascending)")
     */
    public String getDisplayName();

    /**
     * @return whether this sort is selected in the current query or not
     */
    public boolean isSelected();

}
