/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.commerce.api;

import aQute.bnd.annotation.ProviderType;

/**
 * {@code OrderHistoryTraitDataProvider} is a service interface for services which process the order history to
 * extract relevant data and provide it for a given order history trait.
 * The provided data is placed in the orderhistory context store where the related order history trait can access it
 * for evaluation.
 * Implementations of this service should follow certain rules (see {@link #getTraitData(PlacedOrderResult)})
 * to ensure that the data can be rendered in a human readable manner in the client context by the provided
 * orderhistory context store renderer.
 * A trait can access in the client context the data returned by {@link #getTraitData(PlacedOrderResult)} using its
 * jsObject parameter with the following value: clientcontext.orderhistory.traits.<i>identifier</i>.data, where
 * <i>identifier</i> is the string returned by {@link #getIdentifier()}.
 */
@ProviderType
public interface OrderHistoryTraitDataProvider {
    /**
     * Returns the string identifier of the trait for which this service is providing data.
     * It will be used as a JavaScript object property in the trait.
     *
     * @return the order history trait identifier
     */
    String getIdentifier();

    /**
     * Returns a human readable name of the related trait.
     * Used as a label in the client context when rendering the trait data.
     * @return the name of the trait
     */
    String getName();

    /**
     * Extracts data from order history relevant to the trait. The extracted data should be minimal, focused, most
     * often of statistical nature and strictly targeted to the needs of the related trait.
     * Returning the order history or large parts of it can have undesired implications regarding storage,
     * network traffic and security therefor it should be avoided.
     * The data returned by this method can be {@code Object}, {@code Collection&lt;Object&gt;} and
     * {@code Map&lt;String, Object&gt;} where {@code Object} should be a {@code String} or other data type which
     * represents an atomic value having concise string representation provided by {@code toString()}.
     * These return values are supported by the client context render.
     *
     * @param result the order history
     * @return the extracted data
     * @throws CommerceException
     */
    Object getTraitData(PlacedOrderResult result) throws CommerceException;
}
