/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.commerce.api;

import aQute.bnd.annotation.ConsumerType;

/**
 * Interface that describes pagination information, such as number of pages, total results, ...
 */
@ConsumerType
public interface PaginationInfo {
    
    /**
     * Get the number of products in a page
     * @return
     */
    public int getPageSize();

    /**
     * Get the current page, starting from 0
     * @return
     */
    public int getCurrentPage();

    /**
     * Get the total number of pages, starting from 1
     * @return
     */
    public int getTotalPages();

    /**
     * Get the total number of results
     * @return
     */
    public int getTotalResults();
    
}
