/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.commerce.api;

import aQute.bnd.annotation.ProviderType;

/**
 * Interface that describes a payment method.
 */
@ProviderType
public interface PaymentMethod {

    /**
     * Get the path of the payment method if represented in the repository.  Otherwise, an ID
     * uniquely identifying the payment method to the external commerce engine.
     * @return
     */
    public String getPath();

    /**
     * Return the name of a predicate which can be used to identify this payment method's
     * properties within an order.
     * @return
     */
    public String getPredicate();

    /**
     * Return a shopper-oriented title.  (Any author-oriented titles/messages required can be
     * returned via {@link #getProperty}.)
     * @return
     */
    public String getTitle();

    /**
     * Return a shopper-oriented description.  (Any author-oriented titles/messages required
     * can be returned via {@link #getProperty}.)
     * @return
     */
    public String getDescription();

    /**
     * Return a shopper-oriented image identifying the payment method.
     * @param selector An implementation-defined selector for image processing/selection (such
     *                 as a sizing parameter, image-type, etc.)
     * @return
     */
    public String getImageUrl(String selector);

    /**
     * Return a path to any additional content to be displayed (such as form fields to collect
     * data relevant to the payment, etc.)
     * Return null if data is not collected through CQ.
     * @return
     */
    public String getUIPath();

    /**
     * Return a URL to redirect to for data collection, or <code>null</code> if no redirect
     * (or no data collection) is required.
     * @return
     */
    public String getRedirectUrl();

    /**
     * Fetch implementation-defined properties from a payment method.
     * @param name The property name
     * @param type The type the property value should be converted to
     * @return
     */
    public <T> T getProperty(String name, Class<T> type);

}
