/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.commerce.api;

import java.util.List;
import java.util.Map;

import aQute.bnd.annotation.ConsumerType;
import com.adobe.cq.commerce.api.promotion.VoucherInfo;
import com.adobe.cq.commerce.api.promotion.PromotionInfo;
import org.apache.commons.collections.Predicate;

/**
 * Represents an historical order (ie: one that has already been placed).
 */
@ConsumerType
public interface PlacedOrder {
    /**
     * Get an invariant ID for the order.
     * @return
     * @throws CommerceException
     */
    public String getOrderId() throws CommerceException;

    /**
     * Get the order details.
     * @return A map of properties describing the cart line items and order details.
     * @throws CommerceException
     */
    public Map<String, Object> getOrder() throws CommerceException;

    /**
     * Get detailed price information.
     * @param filter An optional predicate used for filtering the {@link PriceInfo}s.
     * @return A list of {@link PriceInfo}s.
     * @throws CommerceException
     * @see CommerceSession#getPriceInfo
     */
    public List<PriceInfo> getCartPriceInfo(Predicate filter) throws CommerceException;

    /**
     * Shortcut for getting a formatted string of the first applicable price, according to the filter.
     *
     * @param filter An optional predicate used for filtering the {@link PriceInfo}s.
     * @return Formatted price string of first matching price
     * @throws CommerceException
     */
    public String getCartPrice(Predicate filter) throws CommerceException;

    /**
     * Return the list of items from a previously-placed order.
     * @throws CommerceException
     */
    public List<CommerceSession.CartEntry> getCartEntries() throws CommerceException;

    /**
     * Return the list of promotions that were applied to a previously-placed order.
     * @throws CommerceException
     */
    public List<PromotionInfo> getPromotions() throws CommerceException;

    /**
     * Return the list of vouchers from a previously-placed order.
     * @throws CommerceException
     */
    public List<VoucherInfo> getVoucherInfos() throws CommerceException;
}

