/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.commerce.api;

import aQute.bnd.annotation.ProviderType;

import java.util.List;

/**
 * Class that describes the results of an order history query.
 *
 * @since 5.6.200
 */
@ProviderType
public class PlacedOrderResult {
    protected PaginationInfo paginationInfo;
    protected List<CommerceSort> sorts;
    protected List<PlacedOrder> orders;

    /**
     * Instantiate a new PlacedOrderResult.
     * @param orders
     * @param sorts
     * @param paginationInfo
     */
    public PlacedOrderResult(List<PlacedOrder> orders, List<CommerceSort> sorts, PaginationInfo paginationInfo) {
        this.paginationInfo = paginationInfo;
        this.sorts = sorts;
        this.orders = orders;
    }

    /**
     * Get pagination information, like page number, total results.
     * @return
     */
    public PaginationInfo getPaginationInfo() {
        return paginationInfo;
    }

    /**
     * Get the available sort fields.
     * @return
     */
    public List<CommerceSort> getSorts() {
        return sorts;
    }

    /**
     * Get the current range of placed orders.
     * @return
     */
    public List<PlacedOrder> getOrders() {
        return orders;
    }
}
