/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.commerce.api;

import aQute.bnd.annotation.ProviderType;
import org.apache.sling.api.resource.ValueMap;

/**
 * A ProductRelationship provides information about a relationship between some context (shopper,
 * cart, page and/or product) and a product.
 *
 * <p>Additional metadata regarding either the relationship or the product can also be included.
 * See {@link ProductRelationshipsProvider} for further details.</p>
 */
@ProviderType
public interface ProductRelationship {

    /**
     * @return a string token identifying the relationship type (cross-sell, warranty, best-seller,
     * trending-product, etc.)
     */
    public String getRelationshipType();

    /**
     * @return a string identifying the relationship type to an author
     */
    public String getRelationshipTitle();

    /**
     * @return the related product
     */
    public Product getProduct();

    /**
     * @return a read-/write-able collection of metadata regarding the product and/or relationship
     */
    public ValueMap getMetadata();
}
