/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.commerce.api;

import aQute.bnd.annotation.ProviderType;
import com.day.cq.wcm.api.Page;
import org.apache.sling.api.SlingHttpServletRequest;

import java.util.List;
import java.util.Map;

/**
 * A ProductRelationshipsProvider provides a list of {@link ProductRelationship}s for a particular
 * context (shopper, cart, page, product).
 *
 * <p>It should be noted that the out-of-the-box RelatedProducts ClientContext store includes the
 * product's SKU, title, imageUrl and path, and all the relationship's metadata, into the ClientContext.
 * A RelationshipsProvider can therefore chose to have other product fields included in the ClientContext
 * simply by copying them to the relationship's metadata.</p>
 *
 * <p>As an example, one might include two properties regarding the relationship (source and message),
 * and an additional product property (the price):
 * <ul>
 *     <li><code>source: "order-history"</code></li>
 *     <li><code>message: "Recommended because you purchased 'Amy Winehouse' in the past"</code></li>
 *     <li><code>price: "$12.50"</code></li>
 * </ul>
 * </p>
 */
@ProviderType
public interface ProductRelationshipsProvider {

    /**
     * Implementations which support only a single relationshipType are encouraged to place that
     * relationshipType into an OSGi property so that ProductRelationshipsProviders can be selected
     * by type.
     */
    public static final String RELATIONSHIP_TYPE_PN = "commerce.productRelationshipsProvider.type";

    /**
     * @return a map which maps the <code>relationshipType</code>s supported by this provider to their
     * <code>relationshipTitle</code>s)
     */
    public Map<String, String> getRelationshipTypes();

    /**
     * @param request A request representing the current user
     * @param session The current commerce session (cart, order)
     * @param page The current page
     * @param product The current product (if applicable)
     * @return a list of {@link ProductRelationship}s for a given context (user, cart, page, product)
     * @throws CommerceException
     */
    public List<ProductRelationship> getRelationships(SlingHttpServletRequest request, CommerceSession session,
                                                      Page page, Product product) throws CommerceException;
}
