/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.commerce.api.asset;

import java.util.Map;

import aQute.bnd.annotation.ConsumerType;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

/**
 * OSGi Service interface for managing product assets.
 */
@ConsumerType
public interface ProductAssetHandler {

    /**
     * Returns the handler name.
     * @return
     */
    public String getHandlerName();

    /**
     * Returns the rendering properties associated with the referenced asset.
     *
     * @param resolver The resource resolver
     * @param assetReference The path to the referenced asset
     * @return
     */
    public Map<String, Object> getAssetProperties(ResourceResolver resolver, String assetReference);

    /**
     * Returns the path of the asset that is referenced in the product asset.
     *
     * @param productAssetResource The product asset resource
     * @return
     */
    public String getReferencedAsset(Resource productAssetResource);

    /**
     * Indicates whether the asset (referenced by its path) is supported or not.
     *
     * @param resolver The resource resolver
     * @param assetReference The path to the referenced asset
     * @return
     */
    public boolean isSupportedReferencedAsset(ResourceResolver resolver, String assetReference);

    /**
     * Indicates whether the product asset is supported or not.
     *
     * @param productAssetResource The product asset resource
     * @return
     */
    public boolean isSupportedAsset(Resource productAssetResource);

    /**
     * Returns the URL to the product's thumbnail image, based on the given selector string.
     *
     * @param productAssetResource The product asset
     * @param selectorString The selector string
     * @return
     */
    public String getThumbnailUrl(Resource productAssetResource, String selectorString);

    /**
     * Indicates whether the handler is active or not.
     * @return
     */
    public boolean isActive();

}