/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.commerce.api.asset;

import java.util.List;

import aQute.bnd.annotation.ConsumerType;

/**
 * OSGi Service interface for accessing registered <code>ProductAssetHandler</code> instances.
 */
@ConsumerType
public interface ProductAssetHandlerProvider {

    /**
     * Returns the list of <code>ProductAssetHandler</code> registered instances.
     * @return
     */
    public List<ProductAssetHandler> getProductAssetHandlers();

    /**
     * Returns the name of the fallback handler.
     * @return
     */
    public String getFallbackHandler();

}
