/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.commerce.api.classification;

import aQute.bnd.annotation.ProviderType;

/**
 * A <code>Classification<code> organizes products into <code>ClassificationCategory</code>s
 * in a tree-like structure. The root category is the root of the category tree.
 *
 * Products can be organized independently from product catalog structures in separate classifications.
 *
 * Since 6.2
 */
@ProviderType
public interface Classification {

    /**
     * Returns the title of the classification.
     *
     * @return title of the classification.
     */
    public String getTitle();

    /**
     * Returns the description of the classification.
     *
     * @return description of the classification.
     */
    public String getDescription();

    /**
     * Returns the path of the classification if represented in the repository. Otherwise, it returns an ID
     * uniquely identifying the classification to the external commerce engine.
     *
     * @return path/ID of the classification.
     */
    public String getPath();

    /**
     * Returns the root category of the classification.
     *
     * @return root category of the classification.
     */
    public ClassificationCategory getRootCategory();

}
