/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.commerce.api.classification;

import aQute.bnd.annotation.ProviderType;

/**
 * The <code>ClassificationAttribute<code> is a product property that helps specify a <code>ClassificationCategory</code>.
 *
 * The name of an attribute matches the name of a product property (e.g. length).
 * The type of an attribute matches the type of the product property (e.g. cm).
 * A <code>ClassificationCategory</code> can have several attributes, e.g. voltage, weight, measurement.
 *
 * Since 6.2
 */
@ProviderType
public interface ClassificationAttribute {

    /**
     * Returns the path of the attribute if represented in the repository. Otherwise, it returns an ID
     * uniquely identifying the attribute to the external commerce engine.
     *
     * @return path/ID of the attribute.
     */
    public String getPath();

    /**
     * Returns the title of the attribute.
     *
     * @return title of the attribute.
     */
    public String getTitle();

    /**
     * Returns the description of the attribute.
     *
     * @return description of the attribute.
     */
    public String getDescription();

    /**
     * Returns the name of the attribute. The attribute name matches the product property.
     *
     * @return name of the attribute.
     */
    public String getName();

    /**
     * Returns the unit of the attribute (e.g: kg).
     *
     * @return unit of the attribute.
     */
    public String getUnit();

}
