/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.commerce.api.promotion;

import java.util.List;

import aQute.bnd.annotation.ProviderType;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;

/**
 * Interface that describes a promotion.
 *
 * Note: this interface only describes a promotion outside of the context of a shopping
 * cart (or placed order).  To get real-time info regarding the application of promotions
 * to a cart, use {@link PromotionInfo}.
 *
 * JCR-based promotions use a {@link PromotionHandler} to define their business logic
 * (such as generating author- and/or shopper-oriented messages, applying discounts to
 * the cart and/or order, etc.).  Use the {@link PromotionManager} to look up an appropriate
 * handler based on the promotion's <code>type</code>.
 *
 * @since 5.6
 */
@ProviderType
public interface Promotion extends Adaptable {

    public static final String PROMOTION_RESOURCE_TYPE = "commerce/components/promotion";

    /**
     * Get the path of the promotion if represented in the repository.  Otherwise, an ID
     * uniquely identifying the promotion to the external commerce engine.
     * @return
     */
    public String getPath();

    /**
     * Return a title used to describe the promotion to authors.
     * @return
     */
    public String getTitle();

    /**
     * Return a description used to describe the promotion to authors.
     * @return
     */
    public String getDescription();

    /**
     * Return the configured promotion type.
     *
     * <p>For JCR-based promotions, the type is used to select a {@link PromotionHandler} which
     * defines the business logic for the promotion.</p>
     *
     * <p>For external promotions, the type is implementation-dependent (and may be
     * <code>null</code>).</p>
     *
     * @return
     */
    public String getType();

    /**
     * Return the promotion's priority.
     * @return
     */
    public long getPriority();

    /**
     * If a promotion wishes to be assigned based on CQ segmentation, it should return the
     * list of segements it is active for here.  Otherwise, return <code>null</code>.
     * @return
     */
    public List<String> getSegments();

    /**
     * Return if the promotion is currently valid. This is often used to enforce start and
     * expiration dates, but actual semantics are implementation-dependent.
     * @return
     */
    public boolean isValid();

    /**
     * @return A resource representing the Promotion's configuration
     * @deprecated since 5.6.200; use {@link #getConfig()} instead.
     */
    @Deprecated
    public Resource getConfigResource();

    /**
     * Return a map of implementation-specific configuration properties.
     * @return
     */
    public ValueMap getConfig();
}
