/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.commerce.api.promotion;

import aQute.bnd.annotation.ProviderType;
import com.adobe.cq.commerce.api.PriceInfo;

/**
 * A POJO which provides information about an <b>applied</b> promotion (including its status and
 * any applied discount).
 *
 * @since 5.6
 */
@ProviderType
public class PromotionInfo {

    /**
     * Status of an applied promotion in the context of a user's cart or order. An applied promotion
     * is either:
     * <ul>
     *     <li><code>NOT_APPLICABLE</code>: no conditions are currently met</li>
     *     <li><code>POTENTIAL</code>: some, but not all, conditions are currently met</li>
     *     <li><code>FIRED</code>: all conditions are met</li>
     * </ul>
     */
    public enum PromotionStatus {
        POTENTIAL, FIRED, NOT_APPLICABLE
    }

    private String path;
    private String title;
    private PromotionStatus status;
    private String description;
    private String message;
    private Integer cartEntryIndex;

    /**
     * Instantiate a new <code>PromotionInfo</code>.
     * @param path The path of the promotion if represented in the repository.  Otherwise, an ID uniquely
     *             identifying the promotion.
     * @param title An author-oriented title.
     * @param status See {@link PromotionStatus}.
     * @param description An author-oriented description of the promotion (and its current status).
     * @param message A shopper-oriented message regarding the current status of the promotion.
     * @param cartEntryIndex The index of the cart entry this promotion applies to, or <code>null</code>
     *                       for order-specific promotions.
     */
    public PromotionInfo(String path, String title, PromotionStatus status, String description, String message, Integer cartEntryIndex) {
        this.path = path;
        this.title = title;
        this.status = status;
        this.message = message;
        this.description = description;
        this.cartEntryIndex = cartEntryIndex;
    }

    /**
     * Get the path or identifier.
     */
    public String getPath() {
        return path;
    }

    /**
     * An author-oriented title.
     */
    public String getTitle() {
        return title;
    }

    /**
     * Get the status.
     */
    public PromotionStatus getStatus() {
        return status;
    }

    /**
     * An author-oriented description of the current status of the promotion.
     */
    public String getDescription() {
        return description;
    }

    /**
     * A shopper-oriented message regarding the current status of the promotion.
     */
    public String getMessage() {
        return message;
    }

    /**
     * Get a cart entry's index in case the promotion is related to a specific cart line item, e.g. discount
     * for seasonal products.
     * For order-level promotions, this method returns <code>null</code>.
     */
    public Integer getCartEntryIndex() {
        return cartEntryIndex;
    }


    /*
     * ==================================================================================================
     * Deprecated methods.  For backwards-compatibility only.
     * ==================================================================================================
     */

    /**
     * @deprecated since 6.0; use {@link PromotionInfo(String, String, PromotionStatus, String, String,
     * Integer, PriceInfo)} instead
     */
    @Deprecated
    public PromotionInfo(String path, String title, PromotionStatus status, String message) {
        this.path = path;
        this.title = title;
        this.status = status;
        this.message = message;

        this.description = null;
        this.cartEntryIndex = null;
    }

}
