/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.commerce.api.promotion;

import java.util.List;
import java.util.Map;

import aQute.bnd.annotation.ProviderType;
import org.apache.sling.api.SlingHttpServletRequest;

import com.adobe.cq.commerce.common.promotion.AbstractJcrVoucher;
import org.apache.sling.api.resource.ResourceResolver;

/**
 * A service which provides access to promotions and vouchers.
 *
 * @since 5.6
 */
@ProviderType
public interface PromotionManager {

    /**
     * Get a map of promotion paths to their firing segments.
     * @param request The request being processed.
     * @return A <code>Map&lt;String, String></code> mapping each promotion's path to its
     * list of segments as a coma-separated <code>String</code>. Promotions are excluded
     * when either not valid, i.e. not within their on/offTimes, or not visible to
     * the user represented by the request.
     */
    public Map<String, String> getPromotionsMap(SlingHttpServletRequest request);

    /**
     * Get the list of available promotions.
     * @param resourceResolver a Sling ResourceResolver instance
     * @return  A <code>List&lt;Promotion&gt;</code> containing the promotions.
     */
    public List<Promotion> getAvailablePromotions(ResourceResolver resourceResolver);

    /**
     * Find a {@link com.adobe.cq.commerce.common.promotion.AbstractJcrVoucher} by voucher code.
     * @param request The request being processed.
     * @param code The voucher code to search for.
     * @return The JcrVoucher, or null if not found or insufficient permissions.
     * @deprecated since 6.0; use {@link #findVoucher} instead
     */
    @Deprecated
    public AbstractJcrVoucher getVoucher(SlingHttpServletRequest request, String code);

    /**
     * Find a {@link Voucher} by voucher code.
     * @param request The request being processed.
     * @param code The voucher code to search for.
     * @return The Voucher, or null if not found or insufficient permissions.
     */
    public Voucher findVoucher(SlingHttpServletRequest request, String code);

    /**
     * Find a registered handler for the particular promotion type.
     * @param promotionType
     * @return The promotion handler for the given promotion type
     */
    public PromotionHandler getHandler(String promotionType);
}
