/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.commerce.api.promotion;

import aQute.bnd.annotation.ProviderType;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ValueMap;

/**
 * Interface that describes a voucher.
 *
 * Note: this interface only describes a voucher outside of the context of a shopping
 * cart.  To get real-time info regarding the application of vouchers to a cart, use
 * {@link VoucherInfo}.
 *
 * @since 5.6
 */
@ProviderType
public interface Voucher {

    /**
     * Get the voucher code. This is normally the string the shopper would type into the
     * cart.
     *
     * NB: while generally unique within a given time-frame, voucher codes are often
     * reused in non-overlapping time-frames.  It is also possible to use a priority
     * to disambiguate several vouchers sharing the same voucher code.
     *
     * @return
     */
    public String getCode();

    /**
     * Get the path of the voucher if represented in the repository.  Otherwise, an ID
     * uniquely identifying the voucher to the external commerce engine.
     * @return
     */
    public String getPath();

    /**
     * Return an author-oriented title.
     * @return
     */
    public String getTitle();

    /**
     * Return an author-oriented description.
     * @return
     */
    public String getDescription();

    /**
     * Return if the voucher is currently valid. This is often used to enforce start and
     * expiration dates, but actual semantics are implementation-dependent.
     * @param request The request representing the current session
     * @return
     */
    public boolean isValid(SlingHttpServletRequest request);

    /**
     * Get the priority.  This allows vouchers sharing the same code (but coming from
     * different campaigns) to be disambiguated.
     * @return
     */
    public long getPriority();

    /**
     * Return a shopper-visible message detailing the current status.
     * @param request The request representing the current session
     * @return
     */
    public String getMessage(SlingHttpServletRequest request);

    /**
     * Return a shopper-visible message detailing why the voucher is invalid.
     * @param request The request representing the current session
     * @return
     * @deprecated since 5.6.200; use {@link #getMessage(SlingHttpServletRequest)} instead
     */
    @Deprecated
    public String getInvalidMessage(SlingHttpServletRequest request);

    /**
     * Return a map of implementation-specific configuration properties.
     * @return
     */
    public ValueMap getConfig();
}
