/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.commerce.api.promotion;


import aQute.bnd.annotation.ProviderType;

/**
 * A POJO which provides information about an <b>applied</b> voucher (including its status and any
 * applied discount).
 *
 * @since 5.6.200
 */
@ProviderType
public class VoucherInfo {

    private String code;
    private String path;
    private String title;
    private String description;
    private boolean isValid;
    private String message;

    /**
     * Instantiate a new <code>VoucherInfo</code>.
     * @param code The voucher code which is typed in by the shopper.
     * @param path The path of the voucher if represented in the repository.  Otherwise, an ID uniquely
     *             identifying the voucher.
     * @param title An author-oriented title.
     * @param description An author-oriented description of the voucher (and its current status).
     * @param isValid For a cart, whether or not the voucher is current valid.  For a placed order, whether
     *                or not the voucher was valid when the order was placed.
     * @param message A shopper-oriented message.
     */
    public VoucherInfo(String code, String path, String title, String description, boolean isValid, String message) {
        this.code = code;
        this.path = path;
        this.title = title;
        this.description = description;
        this.isValid = isValid;
        this.message = message;
    }

    /**
     * Get the path of the voucher if represented in the repository.  Otherwise, an ID
     * uniquely identifying the voucher to the external commerce engine.
     */
    public String getPath() {
        return path;
    }

    /**
     * An author-oriented title.
     */
    public String getTitle() {
        return title;
    }

    /**
     * An author-oriented description of the voucher.
     */
    public String getDescription() {
        return description;
    }

    /**
     * Get the voucher code. This is normally the string the shopper would type into the
     * cart.
     *
     * NB: while generally unique within a given time-frame, voucher codes are often
     * reused in non-overlapping time-frames.  It is also possible to use a priority
     * to disambiguate several vouchers sharing the same voucher code.
     */
    public String getCode() {
        return code;
    }

    /**
     * Return if the voucher is currently valid. This is often used to enforce start and
     * expiration dates, but actual semantics are implementation-dependent.
     */
    public boolean getIsValid() {
        return isValid;
    }

    /**
     * A shopper-oriented message regarding the current status of the voucher.
     */
    public String getMessage() {
        return message;
    }

}
