/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.commerce.api.smartlist;

import aQute.bnd.annotation.ProviderType;
import com.adobe.cq.commerce.api.CommerceException;
import com.adobe.cq.commerce.api.collection.ProductCollection;

import java.util.Iterator;
import java.util.Map;

/**
 * Smart list (sometimes also called wish list) is an ordered collection of {@link SmartListEntry} (products including
 * quantity and other properties). The smart list does not store the actual products, it only points to them by the
 * given <code>path</code> or an ID uniquely identifying them to the external commerce engine.
 */
@ProviderType
public interface SmartList extends ProductCollection {

    /**
     * Adds a new smart list entry in the collection at the last position
     *
     * @param smartListEntry smart list entry to be added
     *
     * @throws CommerceException if the operation fails, if collection already contained
     *          the product/collection or product/collection is null.
     */
    void add(SmartListEntry smartListEntry) throws CommerceException;

    /**
     * Updates the smart list entry.
     *
     * @param path The smart list entry (product) path/ID.
     * @param properties The additional data for smart list entry like updated quantity value
     * @throws CommerceException if the smart list entry was not updated
     */
    void update(String path, Map<String, Object> properties) throws CommerceException;

    /**
     * Returns an iterator over smart list entries referred in the collection in the specified order.
     *
     * @return iterator over smart list entries referred in collection.
     */
    Iterator<SmartListEntry> getSmartListEntries();

    /**
     * Returns the owner id of the smart list.
     *
     * @return the owner id
     */
    String getOwner();

    /**
     * Return <code>true</code> if the smart list is the default smart list, otherwise <code>false</code>. Each user has
     * exactly one default smart list.
     *
     * @return <code>true</code> for the default smart list
     */
    boolean isDefault();

    /**
     * Get the sharing & privacy status of a smart-list.
     *
     * @return The <code>Privacy</code> of the smart-list.
     */
    Privacy getPrivacy();

    /**
     *The available status of a smart-list.
     */
    public enum Privacy {
        PERSONAL, SHARED_READONLY, SHARED_EDITABLE, PUBLIC;
    }
}

