/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.commerce.api.smartlist;

import com.adobe.cq.commerce.api.Product;

import java.util.Calendar;
import java.util.Map;

/**
 * <code>CartEntry</code> represents shopping cart line-items with a certain product and quantity.
 */
public interface SmartListEntry {

    /**
     * Get the referenced {@link Product}.
     *
     * @return the product for this smart list entry
     */
    Product getProduct();

    /**
     * Get a smart list entry property with the given type.
     *
     * @param name The property's name
     * @param type The property's type
     * @return The property or <code>null</code> if it doesn't exist
     * or can not be converted to the given type.
     */
    <T> T getProperty(String name, Class<T> type);

    /**
     * Returns the entry properties
     *
     * @return The entry properties as an {@link Map}.
     */
    Map<String, Object> getProperties();

    /**
     * Short cut to get the quantity value.
     *
     * @return the quantity
     */
    int getQuantity();


    /**
     * This method returns the date and time this smart list entry was created.
     * @return A {@link Calendar} representing the creation date and time
     */
    Calendar getCreated();
}
