/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.commerce.common;

import aQute.bnd.annotation.ConsumerType;
import com.adobe.cq.commerce.api.CommerceServiceFactory;
import com.adobe.granite.security.user.UserPropertiesService;
import com.day.cq.wcm.api.LanguageManager;

import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.settings.SlingSettingsService;

/**
 * Abstract {@link CommerceServiceFactory} implementation which provides the service references
 * for an {@link AbstractJcrCommerceService}.
 */
@Component(componentAbstract = true, metatype = false)
@ConsumerType
public abstract class AbstractJcrCommerceServiceFactory implements CommerceServiceFactory {

    @Reference
    protected LanguageManager languageManager;

    @Reference
    protected UserPropertiesService userPropertiesService;

    @Reference
    protected SlingSettingsService slingSettingsService;

    @Reference
    protected SlingRepository slingRepository;

    @Reference
    protected CommerceSearchProviderManager searchProviderManager;

    /**
     * @deprecated use {@link ServiceContext} instead.
     */
    @Deprecated
    public class Services {
        LanguageManager languageManager;
        UserPropertiesService userPropertiesService;
        SlingSettingsService slingSettingsService;
        SlingRepository slingRepository;
    }

    /**
     * @deprecated use {@link #getServiceContext()} instead.
     * @return
     */
    @Deprecated
    protected Services getServices() {
        Services services = new Services();
        services.languageManager = languageManager;
        services.userPropertiesService = userPropertiesService;
        services.slingSettingsService = slingSettingsService;
        services.slingRepository = slingRepository;
        return services;
    }

    /**
     * Returns the {@code ServiceContext} for this service factory.
     */
    protected ServiceContext getServiceContext() {
        return new ServiceContext(this);
    }
}
