/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.commerce.common;

import com.adobe.cq.commerce.api.Product;
import com.adobe.cq.commerce.api.VariantFilter;

/**
 * A {@link VariantFilter} for filtering variants by the given axis.
 *
 * <p>The following example returns a list of variants which have a value of "blue" on the
 * "color" axis:
<pre>
    product.getVariants(new AxisFilter("color", "blue"));
</pre>
 *
 * <p>The wildcard "*" is supported for values.  The following example will return all
 * variants that have a "color" property:
<pre>
    product.getVariants(new AxisFilter("color", "*"));
</pre>
 */
public class AxisFilter implements VariantFilter {
    
    private String axis;
    private String targetValue;

    public AxisFilter(String axis, String value) {
        this.axis = axis;
        this.targetValue = value;
    }

    public boolean includes(Product product) {
        String value = product.getProperty(axis, String.class);
        if (value != null) {
            return (targetValue.equals("*") || targetValue.equals(value));
        }
        return false;
    }
}
