/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.commerce.common;

import aQute.bnd.annotation.ConsumerType;
import com.adobe.cq.commerce.api.CommerceException;
import com.adobe.cq.commerce.api.CommerceQuery;
import com.adobe.cq.commerce.api.CommerceResult;
import com.adobe.cq.commerce.api.CommerceService;

/**
 * The {@code CommerceSearchProvider} is the common interface of search providers for the e-commerce
 * system.
 * A search provider implements the backend of the search system and can be plugged into the
 * e-commerce system  to provide search functionality tailored to the special needs of a certain
 * application domain.
 *
 * @see com.adobe.cq.commerce.common.AbstractJcrCommerceService#getSearchProvider()
 */
@ConsumerType
public interface CommerceSearchProvider {

    /**
     * Property name for the 'name' property of a {@code CommerceSearchProvider} service.
     */
    public static final String NAME_PROPERTY = "commerce.search.provider.name";

    /**
     * Perform a search.
     * @param query the search query as a {@code CommerceQuery}
     * @param service the commerce service requesting the search
     * @return a the search results as a {@code CommerceResult}
     * @throws CommerceException if an error occurs during the search process.
     */
    public CommerceResult search(CommerceQuery query, CommerceService service) throws CommerceException;
}
