/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.commerce.common;

import aQute.bnd.annotation.ProviderType;

/**
 * {@code CommerceSearchProviderManager} defines the service to provide access to {@code CommerceSearchProvider}
 * instances available in the system.
 * The commerce search providers are registered in the manager by name and can be accessed by name with the
 * {@code getSearchProvider(String name)} method.
 */
@ProviderType
public interface CommerceSearchProviderManager {

    /**
     * Find a registered commerce search provider service for the specified service name.
     * @param name the name of the service
     * @return the provider registered {@code CommerceSearchProvider} service instance or
     * {@code null) if no service was registered with the specified name.
     */
    CommerceSearchProvider getSearchProvider(String name);
}
