/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.commerce.common;

import org.apache.sling.api.resource.Resource;

import com.day.cq.commons.inherit.InheritanceValueMap;

/**
 * An {@link InheritanceValueMap} for a given {@link Resource} that will inherit values from
 * ancestors up to its ancestral component, but no higher.
 * 
 * <p>
 *     For example, given: <code>/content/parent/page/jcr:content/footer/image/@width</code>,
 *     the <code>ComponentInheritanceValueMap</code> will search for a width property in:
 *     <ul>
 *         <li><code>/content/parent/page/jcr:content/footer/image/@width</code></li>
 *         <li><code>/content/parent/page/jcr:content/footer/@width</code></li>
 *         <li><code>/content/parent/page/jcr:content/@width</code></li>
 *     </ul>
 *     Having not found it in any of those locations, it will then return <code>null</code>.
 *
 * <p>
 *     Note that <code>ComponentInheritanceValueMap</code> searches <b>only</b> the component
 *     hierarchy.  It will <b>not</b> (for instance), look in:
 *     <ul>
 *         <li><code>/content/parent/jcr:content/footer/image/@width</code></li>
 *     </ul>
 *     See {@link com.day.cq.commons.inherit.HierarchyNodeInheritanceValueMap} for that
 *     functionality.
 */
@Deprecated // since 5.6.1  Use com.day.cq.commons.inherit.ComponentInheritanceValueMap directly.
public class ComponentInheritanceValueMap extends com.day.cq.commons.inherit.ComponentInheritanceValueMap implements InheritanceValueMap {
    public ComponentInheritanceValueMap(Resource resource) {
        super(resource);
    }
}
