/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.commerce.common;

import com.adobe.cq.commerce.api.CommerceFacet;
import com.adobe.cq.commerce.api.CommerceFacetValue;

import java.util.List;

/**
 * Default implementation for {@code CommerceFacet}.
 *
 * @see CommerceFacet
 */
public class DefaultCommerceFacet implements CommerceFacet {

    private String id;
    private String displayName;
    private boolean multiSelect;
    private List<CommerceFacetValue> values;

    /**
     * {@inheritDoc}
     */
    public String getId() {
        return id;
    }

    /**
     * {@inheritDoc}
     */
    public String getDisplayName() {
        return displayName;
    }

    /**
     * {@inheritDoc}
     */
    public boolean isMultiSelect() {
        return multiSelect;
    }

    /**
     * {@inheritDoc}
     */
    public List<CommerceFacetValue> getValues() {
        return values;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setMultiSelect(boolean multiSelect) {
        this.multiSelect = multiSelect;
    }

    @SuppressWarnings("unchecked")
    public void setValues(List<? extends CommerceFacetValue> values) {
        this.values = (List<CommerceFacetValue>) values;
    }

}
