/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.commerce.common;

import com.adobe.cq.commerce.api.CommerceFacetValue;

/**
 * Default implementation for {@code CommerceFacetValue}.
 *
 * @see CommerceFacetValue
 */
public class DefaultCommerceFacetValue implements CommerceFacetValue, Comparable<DefaultCommerceFacetValue> {

    private String id;
    private String displayName;
    private int productCount;
    private boolean selected;

    /**
     * {@inheritDoc}
     */
    public String getId() {
        return id;
    }

    /**
     * {@inheritDoc}
     */
    public String getDisplayName() {
        return displayName;
    }

    /**
     * {@inheritDoc}
     */
    public int getProductCount() {
        return productCount;
    }

    /**
     * {@inheritDoc}
     */
    public boolean isSelected() {
        return selected;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setProductCount(int productCount) {
        this.productCount = productCount;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    /**
     * {@inheritDoc}
     */
    public int compareTo(DefaultCommerceFacetValue that) {
        int val = - (this.productCount - that.productCount);
        if (val == 0) {
            if (this.displayName != null && that.displayName != null) {
                val = this.displayName.compareTo(that.displayName);
            } else if (this.displayName == null && that.displayName != null) {
                val = -1;
            } else if (this.displayName != null) {
                val = 1;
            }
        }

        return val;
    }
}
