/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.commerce.common;

import com.adobe.cq.commerce.api.CommerceFacet;
import com.adobe.cq.commerce.api.CommerceQuery;
import com.adobe.cq.commerce.api.CommerceResult;
import com.adobe.cq.commerce.api.CommerceSort;
import com.adobe.cq.commerce.api.PaginationInfo;
import com.adobe.cq.commerce.api.Product;

import java.util.List;

/**
 * Default implementation for {@code CommerceResult}.
 *
 * @see CommerceResult
 */
public class DefaultCommerceResult implements CommerceResult {

    private PaginationInfo paginationInfo;
    private List<CommerceSort> sorts;
    private List<CommerceFacet> facets;
    private List<Product> products;
    private CommerceQuery originalQuery;
    private CommerceQuery actualQuery;

    /**
     * {@inheritDoc}
     */
    public PaginationInfo getPaginationInfo() {
        return paginationInfo;
    }

    /**
     * {@inheritDoc}
     */
    public List<CommerceSort> getSorts() {
        return sorts;
    }

    /**
     * {@inheritDoc}
     */
    public List<Product> getProducts() {
        return products;
    }

    /**
     * {@inheritDoc}
     */
    public CommerceQuery getOriginalQuery() {
        return originalQuery;
    }

    /**
     * {@inheritDoc}
     */
    public CommerceQuery getActualQuery() {
        return actualQuery;
    }

    /**
     * {@inheritDoc}
     */
    public List<CommerceFacet> getFacets() {
        return facets;
    }

    public void setPaginationInfo(PaginationInfo paginationInfo) {
        this.paginationInfo = paginationInfo;
    }

    @SuppressWarnings("unchecked")
    public void setSorts(List<? extends CommerceSort> sorts) {
        this.sorts = (List<CommerceSort>) sorts;
    }

    @SuppressWarnings("unchecked")
    public void setFacets(List<? extends CommerceFacet> facets) {
        this.facets = (List<CommerceFacet>) facets;
    }

    @SuppressWarnings("unchecked")
    public void setProducts(List<? extends Product> products) {
        this.products = (List<Product>) products;
    }

    public void setOriginalQuery(CommerceQuery originalQuery) {
        this.originalQuery = originalQuery;
    }

    public void setActualQuery(CommerceQuery actualQuery) {
        this.actualQuery = actualQuery;
    }

}
