/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.commerce.common;

import com.adobe.cq.commerce.api.PaginationInfo;

/**
 * Default implementation for {@code PaginationInfo}.
 *
 * @see PaginationInfo
 */
public class DefaultPaginationInfo implements PaginationInfo {

    private int pageSize;
    private int currentPage;
    private int totalPages;
    private int totalResults;

    /**
     * {@inheritDoc}
     */
    public int getPageSize() {
        return pageSize;
    }

    /**
     * {@inheritDoc}
     */
    public int getCurrentPage() {
        return currentPage;
    }

    /**
     * {@inheritDoc}
     */
    public int getTotalPages() {
        return totalPages;
    }

    /**
     * {@inheritDoc}
     */
    public int getTotalResults() {
        return totalResults;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    public void setTotalPages(int totalPages) {
        this.totalPages = totalPages;
    }

    public void setTotalResults(int totalResults) {
        this.totalResults = totalResults;
    }
}
