/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.commerce.common;

import com.adobe.cq.commerce.api.Product;
import com.adobe.cq.commerce.api.ProductRelationship;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;

import java.util.HashMap;

/**
 * The default implementation of a {@link ProductRelationship}.
 */
public class DefaultProductRelationship implements ProductRelationship {

    protected String relationshipType;
    protected String relationshipTitle;
    protected Product product;
    protected ValueMap metadata;

    public DefaultProductRelationship(String relationshipType, String relationshipTitle, Product product) {
        this.relationshipType = relationshipType;
        this.relationshipTitle = relationshipTitle;
        this.product = product;
        this.metadata = new ValueMapDecorator(new HashMap<String, Object>());
    }

    /**
     * @return a string token identifying the relationship type (cross-sell, warranty, best-seller,
     * trending-product, etc.)
     */
    public String getRelationshipType() {
        return relationshipType;
    }

    /**
     * @return a string identifying the relationship type to an author
     */
    public String getRelationshipTitle() {
        return relationshipTitle;
    }

    /**
     * @return the related product
     */
    public Product getProduct() {
        return product;
    }

    /**
     * @return a read-/write-able collection of metadata regarding the relationship
     */
    public ValueMap getMetadata() {
        return metadata;
    }
}
