/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.commerce.common;

import com.adobe.cq.commerce.api.Product;
import com.adobe.cq.commerce.api.VariantFilter;

import java.util.HashSet;
import java.util.Set;

/**
 * A {@link VariantFilter} for enumerating variants along a given axis.  A single variation
 * will be returned for each enumeration.
 *
 * <p>For example, given the variations:
 * <ul>
 * <li>small-blue</li>
 * <li>small-black</li>
 * <li>small-tan</li>
 * <li>large-green</li>
 * <li>large-brown</li>
 * <li>large-red</li>
 * </ul>
 * this call:
<pre>
    product.getVariants(new EnumerateAxisFilter("size"));
</pre>
 * will return two products: <code>small-blue</code> and <code>large-green</code>.
 *
 * <p><b>NB</b>: the <i>particular</i> variation chosen to represent each enumeration is
 * not defined.  The example above could have also returned <code>small-black</code> and
 * <code>large-red</code>.
 */
public class EnumerateAxisFilter implements VariantFilter {

    private String axis;
    private Set<String> represented = new HashSet<String>();

    public EnumerateAxisFilter(String axis) {
        this.axis = axis;
    }

    public boolean includes(Product product) {
        String value = product.getProperty(axis, String.class);
        if (value != null && !represented.contains(value)) {
            represented.add(value);
            return true;
        }
        return false;
    }
}
