package com.adobe.cq.commerce.common;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.adobe.cq.commerce.api.CommerceFacet;
import com.adobe.cq.commerce.api.CommerceFacetValue;

/**
 * A utility class for working with facets parameters.
 */
public class FacetParamHelper {

    public static final String PREFIX = "facet_";

    /**
     * Returns facet GET parameters using the provided list as a base, and toggling the value specified by facetId and
     * valueId.
     */
    public static String toParams(final List<CommerceFacet> facets, final String facetId, final String valueId) {
        final Map<String, List<String>> facetMap = new HashMap<String, List<String>>();
        for (final CommerceFacet facet : facets) {
            final List<String> values = new ArrayList<String>();
            facetMap.put(facet.getId(), values);
            for (final CommerceFacetValue value : facet.getValues()) {
                final boolean isToggled = facet.getId().equals(facetId) && value.getId().equals(valueId);
                if (facet.isMultiSelect()) {
                    if ((value.isSelected() && !isToggled) || (!value.isSelected() && isToggled)) {
                        values.add(value.getId());
                    }
                } else {
                    if ((values.size() == 0 && value.isSelected() && !isToggled)
                            || (!value.isSelected() && isToggled)) {
                        values.clear();
                        values.add(value.getId());
                    }
                }
            }
        }

        final StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, List<String>> entry: facetMap.entrySet()) {
            for (String value: entry.getValue()) {
                builder.append("&" + PREFIX + URLEncoder.encode(entry.getKey()) + "=" + URLEncoder.encode(value));
            }
        }

        return builder.length() > 0 ? builder.substring(1) : ""; // remove the leading '&'
    }

    /**
     * Returns facet GET parameters using the provided facet and facet value identifier.
     */
    public static String toParams(String facetId, String valueId) {
        return FacetParamHelper.PREFIX + URLEncoder.encode(facetId) + "=" + URLEncoder.encode(valueId);
    }
}
