/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.commerce.common;

import com.adobe.cq.commerce.api.PriceInfo;
import org.apache.commons.collections.Predicate;

import java.util.Set;

/**
 * Default filter predicate to use with {@link com.adobe.cq.commerce.api.CommerceSession} get-pricing
 * methods.
 */
public class PriceFilter implements Predicate {

    /**
     * In order to use this filter the prices passed to it must have this property set and it has to be a
     * {@link Set} with {@link String} elements, where each element is a price type.
     */
    public static final String PN_TYPES = "com.adobe.cq.commerce.common.PriceFilter.types";

    protected String[] types;

    /**
     * Default constructor. This filter will match prices that contain <strong>all</strong> supplied types.
     * @param types the types this filter has to match. If empty, all prices will be included.
     */
    public PriceFilter(String... types) {
        this.types = types;
    }

    public boolean evaluate(Object object) {
        if (object instanceof PriceInfo) {
            final PriceInfo price = (PriceInfo) object;
            if (price.get(PN_TYPES) instanceof Set) {
                final Set<String> priceTypes = (Set<String>) price.get(PN_TYPES);

                for (String type: types) {
                    if (!priceTypes.contains(type)) {
                        return false;
                    }
                }

                return true;
            }
        }
        return false;
    }

}
