/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.commerce.common;

import com.adobe.granite.security.user.UserPropertiesService;
import com.day.cq.wcm.api.LanguageManager;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.settings.SlingSettingsService;

/**
 * {@code ServiceContext} is a helper class to hold service references used in a CQ commerce
 * implementation.
 * Subclasses can extend it to other bind services and parameters used by custom commerce
 * implementations.
 *
 * @see com.adobe.cq.commerce.common.AbstractJcrCommerceServiceFactory#getServiceContext()
 */
public class ServiceContext {
    /**
     * A reference to the singleton {@link LanguageManager}
     */
    public final LanguageManager languageManager;

    /**
     * A reference to the singleton {@link UserPropertiesService}
     */
    public final UserPropertiesService userPropertiesService;

    /**
     * A reference to the singleton {@link SlingSettingsService}
     */
    public final SlingSettingsService slingSettingsService;

    /**
     * A reference to the singleton {@link SlingRepository}
     */
    public final SlingRepository slingRepository;

    /**
     * A reference to the singleton {@link CommerceSearchProviderManager}
     */
    public final CommerceSearchProviderManager searchProviderManager;

    protected ServiceContext(AbstractJcrCommerceServiceFactory serviceFactory) {
        languageManager = serviceFactory.languageManager;
        userPropertiesService = serviceFactory.userPropertiesService;
        slingSettingsService = serviceFactory.slingSettingsService;
        slingRepository = serviceFactory.slingRepository;
        searchProviderManager = serviceFactory.searchProviderManager;
    }
}
