/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.commerce.common.promotion;

import org.apache.sling.adapter.SlingAdaptable;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;

import com.adobe.cq.commerce.api.CommerceException;
import com.adobe.cq.commerce.api.promotion.Promotion;
import com.adobe.cq.commerce.api.promotion.Voucher;
import com.day.cq.i18n.I18n;
import com.day.cq.wcm.api.Page;

/**
 * {@link Voucher} implementation that reads details from JCR, and delegates to a {@link Promotion}
 * for applying the discount (or other cart modification).
 * @deprecated since 5.6.200; use {@link com.adobe.cq.commerce.impl.promotion.JcrVoucherImpl} instead.
 */
@Deprecated
public class AbstractJcrVoucher extends SlingAdaptable implements Voucher {

    public static final String VOUCHER_RESOURCE_TYPE = "commerce/components/voucher";
    public static final long VOUCHER_DEFAULT_PRIORITY = 100L;

    protected Resource resource;
    protected Page page;

    public AbstractJcrVoucher(Resource resource) throws CommerceException {
        this.resource = resource;
        page = resource.adaptTo(Page.class);
        if (page == null || !ResourceUtil.isA(resource.getChild("jcr:content"), AbstractJcrVoucher.VOUCHER_RESOURCE_TYPE)) {
            throw new CommerceException("Resource is not a JcrVoucher.");
        }
    }

    public String getCode() {
        ValueMap properties = resource.adaptTo(ValueMap.class);
        return properties.get("jcr:content/code", String.class);
    }

    /**
     * Get the path.
     */
    public String getPath() {
        return resource.getPath();
    }

    /**
     * The voucher title, visible only to authors.
     */
    public String getTitle() {
        return page.getTitle();
    }

    /**
     * The voucher description, visible only to authors.
     */
    public String getDescription() {
        return page.getDescription();
    }

    /**
     * A description visible to shoppers.
     */
    public String getMessage() {
        ValueMap properties = resource.adaptTo(ValueMap.class);
        return properties.get("jcr:content/message", "");
    }

    /**
     * If the voucher is part of a campaign, return the campaign's priority. Otherwise return 100.
     * @return The priority
     */
    public long getPriority() {
        for (Page parent = page.getParent(); parent != null; parent = parent.getParent()) {
            if (ResourceUtil.isA(parent.getContentResource(), "cq/personalization/components/campaignpage")) {
                return ResourceUtil.getValueMap(parent.getContentResource()).get("priority", 100);
            }
        }
        return VOUCHER_DEFAULT_PRIORITY;
    }

    /**
     * Valid if the parent campaign's onTime has been reached and the offTime hasn't,
     * or if the times are not specified.
     * @return <code>true</code> if voucher is valid, <code>false</code> otherwise
     */
    public boolean isValid(SlingHttpServletRequest request) {
        for (Page parent = page.getParent(); parent != null; parent = parent.getParent()) {
            if (ResourceUtil.isA(parent.getContentResource(), "cq/personalization/components/campaignpage")) {
                return parent.isValid();
            }
        }
        return false;
    }

    /**
     * Return a shopper-visible message detailing why the voucher is invalid.
     */
    public String getInvalidMessage(SlingHttpServletRequest request) {
        final I18n i18n = new I18n(request);
        for (Page parent = page.getParent(); parent != null; parent = parent.getParent()) {
            if (ResourceUtil.isA(parent.getContentResource(), "cq/personalization/components/campaignpage")) {
                long time = parent.timeUntilValid();
                if (time > 0) {
                    return i18n.get("Invalid coupon code.");   // Don't leak that it might be valid later
                } else if (time < 0) {
                    return i18n.get("JcrVoucher expired.");
                }
            }
        }
        return "";
    }

    /**
     * The promotion associated with the voucher. Promotions are used to apply some change
     * to the shopping cart once the voucher has been added.
     * @return The voucher's promotion
     */
    public Promotion getPromotion() {
        ValueMap properties = resource.adaptTo(ValueMap.class);
        String promoPath = properties.get("jcr:content/promotion", String.class);
        if (promoPath != null && promoPath.length() > 0) {
            Resource promoResource = resource.getResourceResolver().getResource(promoPath);
            return (promoResource == null) ? null : promoResource.adaptTo(Promotion.class);
        } else {
            return null;
        }
    }

    /**
     * {@inheritDoc}
     */
    @SuppressWarnings("unchecked")
    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (type == Resource.class) {
            return (AdapterType)resource;
        } else if (type == Page.class) {
            return (AdapterType)page;
        }

        AdapterType ret = super.adaptTo(type);
        if (ret == null) {
            ret = resource.adaptTo(type);
        }

        return ret;
    }

    public String getMessage(SlingHttpServletRequest request) {
        throw new UnsupportedOperationException();
    }

    public ValueMap getConfig() {
        throw new UnsupportedOperationException();
    }

}