/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.commerce.pim.api;

import java.io.IOException;

import javax.servlet.ServletException;

import aQute.bnd.annotation.ConsumerType;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;

/**
 * A service to which the ProductDataServlet delegates catalog blueprint importing.
 */
@ConsumerType
public interface CatalogBlueprintImporter {

    /**
     * Name of the service property indicating the particular implementation this importer provides,
     * e.g. geometrixx.
     */
    public static final String PROPERTY_COMMERCE_PROVIDER = "commerceProvider";

    /**
     *
     */
    public void importBlueprints(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException;

}
