/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.commerce.pim.api;

import javax.jcr.RepositoryException;

import aQute.bnd.annotation.ProviderType;
import org.apache.sling.api.resource.Resource;

import com.adobe.cq.commerce.api.Product;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.WCMException;

import java.util.List;

/**
 *
 */
@ProviderType
public interface CatalogGenerator {

    public final String NT_CATALOG_ACTION = "cq:CatalogSyncAction";
    public final String NT_CATALOG_SYNC_CONFIG = "cq:CatalogSyncConfig";
    public final String NN_CATALOG_SYNC_CONFIG = "cq:CatalogSyncConfig";

    /**
     * Create a product catalog from a catalog blueprint.
     * @param blueprint
     * @param destinationPath
     * @param name  the node-name of the root page
     * @param title the jcr:title of the root page
     * @param rolloutConfigPaths    a list of rollout configs to use for the template &lt;-> page MSM relationships
     * @return the root page of the catalog
     */
    public Page createCatalog(Page blueprint, String destinationPath, String name, String title, String... rolloutConfigPaths)
            throws WCMException, RepositoryException;

    /**
     * Return a list of target sections.
     * @param section the master section (in the catalog blueprint)
     * @return a <code>List</code> of paths to target sections created from the given master
     */
    public List<String> getTargetPaths(Page section);

    /**
     * Roll-out any changes for a product catalog or product catalog section.
     * @param master    the catalog/section blueprint from which to perform the rollout
     * @param target    the catalog/section page (generated from the blueprint) which should be updated
     * @param reset     true if overrides should be reset
     */
    public void rolloutChanges(Page master, Page target, boolean reset) throws WCMException, RepositoryException;

    /**
     * Convert a product page proxy to a standard, editable page.
     * @param pageProxy     the proxy page to be converted
     * @param templatePage  the template page reference to use for the editable page
     * @param pimProduct    the product reference to use for the editable page
     */
    public void convertToEditablePage(Page pageProxy, Page templatePage, Product pimProduct) throws WCMException, RepositoryException;

    /**
     * Perform the catalog rollout hooks for a given catalog page.  This includes:
     * 1) applying any target properties from the blueprint
     * 2) running any commerce-service-specific rollout hooks for the page
     * @param page
     * @param reset
     */
    public void executePageRolloutHooks(Page page, boolean reset);

    /**
     * Perform the catalog rollout actions for a given product.  This includes:
     * 1) running any commerce-service-specific rollout hooks for the product
     * @param productComponent
     */
    public void executeProductRolloutHooks(Resource productComponent);

    /**
     * Update a slave product component to reflect all its master's variations, images, etc.
     * @param productComponent
     */
    public void updateProduct(Resource productComponent);

    /**
     * Update a slave product image to reflect its master's image.
     * @param productResource
     * @deprecated since 6.1; use {@link #updateProductAssets(Resource productResource)} instead.
     */
    @Deprecated
    public void updateProductImage(Resource productResource);

    /**
     * Update slave product images to reflect its master's images.
     * @param productResource
     * @deprecated since 6.1; use {@link #updateProductAssets(Resource productResource)} instead.
     */
    @Deprecated
    public void updateProductImages(Resource productResource);

    /**
     * Update slave product assets to reflect its master's assets.
     * @param productResource
     */
    public void updateProductAssets(Resource productResource);

}
