package com.adobe.cq.commerce.pim.api;

/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

import aQute.bnd.annotation.ProviderType;
import com.adobe.cq.commerce.api.Product;
import com.day.cq.wcm.api.Page;
import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.Resource;

/**
 * Generates a list of products to be used as a basis for a product feed in various
 * formats (Search&Promote, Target Recommendations etc.).<br/>
 * The list of products is generated based on the product pages that have been rolled-out under a repository path.
 *
 */
@ProviderType
public interface ProductFeedService {

    /**
     * Retrives the full product list under one or more repository paths.
     * The repository paths must contain product pages that have been rolled-out
     *
     * @param root a {@link Resource} object representing the root resource under which the product pages are generated
     * @return a list of {@link Product} objects
     */
    List<Product> getFullProductsList(Page root) throws RepositoryException;

    /**
     * Retrieves a partial product list under one or more repository paths. The timestamp is compared to the
     * <code>cq:lastModified</code> property of the product pages
     *
     * @param root a {@link Resource} object representing the root resource under which the product pages are generated
     * @param timestamp a timestamp reference to generate the incremental list
     * @return a list of {@link Product} objects
     */
    List<Product> getIncrementalProductsList(Page root, long timestamp) throws RepositoryException;

}
