/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.commerce.pim.api;


import java.util.List;

import aQute.bnd.annotation.ProviderType;
import com.adobe.cq.commerce.api.Product;

/**
 * The <code>ProductInfoManager</code> contains administration functions for the
 * management and editing of product data.
 *
 * In the typical Sling context you can also adapt to a {@link ProductInfoManager} from
 * the {@link org.apache.sling.api.resource.ResourceResolver}:
 *
 * <pre><code>
 * ProductInfoManager pim = resourceResolver.adaptTo(ProductInfoManager.class);
 * </code></pre>
 */
@ProviderType
public interface ProductInfoManager {

    /**
     * Finds all products which have at least all the tags given.
     * @param basePath the path under which to search
     * @param matchTags an array of tag names
     * @return a list of {@link Product}s
     */
    public List<Product> findProductsByTag(String basePath, String[] matchTags);

    /**
     * Finds all Products which match the given full-text query.
     * (For details, see {@link com.day.cq.search.SimpleSearch}.)
     * @param basePath the path under which to search
     * @param searchString the text to search for
     * @return a list of {@link Product}s
     */
    public List<Product> findProductsBySearch(String basePath, String searchString);

    /**
     * Finds all products which match an XPath, SQL or SQL2 query.
     * @param queryType must be <code>xpath</code>, <code>sql</code> or <code>sql2</code>
     * @param query the text of the xpath, sql or sql2 query
     * @return a list of {@link Product}s
     */
    public List<Product> findProductsByQuery(String queryType, String query);
}
